/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import cz.insophy.inplan.sdgraph.MaterialSource;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgMatprodNode;
import cz.insophy.inplan.sdgraph.SdgNodeVisitor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public interface SdgNode {
    public Set<SdgNode> getDirectSuccessors();

    default public <T extends SdgNode> Set<T> getDirectSuccessors(Class<T> nodeType) {
        Preconditions.checkArgument(SdgNode.class.isAssignableFrom(nodeType), "%s is not a subclass of SdgNode.", (Object)nodeType.getSimpleName());
        return Sets.newHashSet(Iterables.filter(this.getDirectSuccessors(), nodeType));
    }

    default public Set<SdgNode> getTransitiveSuccessors() {
        HashSet<SdgNode> successors = Sets.newHashSet();
        for (SdgNode sdgNode : this.getDirectSuccessors()) {
            successors.add(sdgNode);
            successors.addAll(sdgNode.getTransitiveSuccessors());
        }
        return successors;
    }

    default public <T extends SdgNode> Set<T> getTransitiveSuccessors(Class<T> nodeType) {
        Preconditions.checkArgument(SdgNode.class.isAssignableFrom(nodeType), "%s is not a subclass of SdgNode.", (Object)nodeType.getSimpleName());
        return Sets.newHashSet(Iterables.filter(this.getTransitiveSuccessors(), nodeType));
    }

    default public Set<SdgNode> getTransitiveSuccessors(Predicate<SdgNode> filter) {
        return Sets.filter(this.getTransitiveSuccessors(), filter::test);
    }

    public Set<SdgNode> getDirectPredecessors();

    default public <T extends SdgNode> Set<T> getDirectPredecessors(Class<T> nodeType) {
        Preconditions.checkArgument(SdgNode.class.isAssignableFrom(nodeType), "%s is not a subclass of SdgNode.", (Object)nodeType.getSimpleName());
        return Sets.newHashSet(Iterables.filter(this.getDirectPredecessors(), nodeType));
    }

    default public Set<SdgNode> getTransitivePredecessors() {
        HashSet<SdgNode> predecessors = Sets.newHashSet();
        for (SdgNode sdgNode : this.getDirectPredecessors()) {
            predecessors.add(sdgNode);
            predecessors.addAll(sdgNode.getTransitivePredecessors());
        }
        return predecessors;
    }

    default public <T extends SdgNode> Set<T> getTransitivePredecessors(Class<T> nodeType) {
        Preconditions.checkArgument(SdgNode.class.isAssignableFrom(nodeType), "%s is not a subclass of SdgNode.", (Object)nodeType.getSimpleName());
        return Sets.newHashSet(Iterables.filter(this.getTransitivePredecessors(), nodeType));
    }

    default public Set<SdgNode> getTransitivePredecessors(Predicate<SdgNode> filter) {
        return Sets.filter(this.getTransitivePredecessors(), filter::test);
    }

    public List<SdgEdge> getOutgoingEdges();

    public List<SdgEdge> getIncomingEdges();

    public List<SdgEdge> getEdgesTo(SdgNode var1);

    public List<SdgEdge> getEdgesFrom(SdgNode var1);

    public boolean isLeaf();

    public boolean isRoot();

    public double getTotalIncomingQty(@Nonnull Material var1);

    public double getTotalOutgoingQty(@Nonnull Material var1);

    default public long getMatprodPreparedTime() {
        if (this.isRoot()) {
            return -9223372036854775708L;
        }
        long time = Long.MIN_VALUE;
        for (SdgEdge edge : this.getIncomingEdges()) {
            time = Math.max(time, edge.getStartTime());
        }
        return time;
    }

    default public long getMaterialPreparedTime() {
        if (this.isRoot()) {
            return -9223372036854775708L;
        }
        long time = Long.MIN_VALUE;
        for (SdgEdge edge : this.getIncomingEdges()) {
            if (edge.getMaterial() instanceof Product) continue;
            time = Math.max(time, edge.getStartTime());
        }
        return time;
    }

    default public long getProductPreparedTime() {
        if (this.isRoot()) {
            return -9223372036854775708L;
        }
        long time = Long.MIN_VALUE;
        for (SdgEdge edge : this.getIncomingEdges()) {
            if (!(edge.getMaterial() instanceof Product)) continue;
            time = Math.max(time, edge.getStartTime());
        }
        return time;
    }

    default public boolean isComplete() {
        return true;
    }

    default public boolean isProductionLeaf() {
        for (SdgNode s2 : this.getDirectSuccessors()) {
            if (s2 instanceof SdgMatprodNode) continue;
            return false;
        }
        return true;
    }

    default public MaterialSource getMaterialSource() {
        MaterialSource source = MaterialSource.UNAVAILABLE;
        for (SdgEdge edge : this.getIncomingEdges()) {
            source = MaterialSource.combineSources(source, edge.getSourceNode());
        }
        return source;
    }

    default public long getProductionStart() {
        long start = Long.MAX_VALUE;
        for (SdgGorNode node : this.getTransitivePredecessors(SdgGorNode.class)) {
            start = Math.min(start, node.getGor().getStartDate());
        }
        if (start == Long.MAX_VALUE) {
            return -1L;
        }
        return start;
    }

    public double getMttQty(@Nonnull Material var1, Collection<? extends SdgNode> var2);

    default public double getMttQty(@Nonnull Material material, SdgNode destinationNode) {
        return this.getMttQty(material, Collections.singletonList(destinationNode));
    }

    public double getMttQty(Collection<? extends SdgNode> var1);

    default public double getMttQty(SdgNode destinationNode) {
        return this.getMttQty(Collections.singletonList(destinationNode));
    }

    public Set<SdgNode> getMttDestinations();

    public Set<SdgNode> getMttSources();

    public double getProbabilisticMttQty(Set<SdgNode> var1);

    default public double getProbabilisticMttQty(SdgNode destination) {
        return this.getProbabilisticMttQty(Sets.newHashSet(destination));
    }

    public <T> T accept(SdgNodeVisitor<T> var1);
}

